def lang(text, defaultlang):
    if defaultlang != "ru_RU":
        match text:
            case "error":
                return "Error"
            case "body":
                return "\nWelcome!\n"
            case "create":
                return "\nNew Asset\n"
            case "info":
                return "\n   Info   \n"
            case "infobody":
                return "\nThis program exists to automatically create Minecraft resource packs for levels in Funkalot map.\n\nIt does not create levels, but provides assets for them, i.e. music and cover art."
            case "choosemusicfile":
                return "Select a Music File"
            case "mp3files":
                return "mp3 files"
            case "oggfiles":
                return "ogg files"
            case "chooseimagefile":
                return "Select a Cover Art"
            case "pngfiles":
                return "png files"
            case "unsupportederror":
                return "Unsupported or unavailable file: "
            case "missingpatherror":
                return "Missing path."
            case "allfiles":
                return "All files"
            case "input":
                return "Input"
            case "namespace":
                return "Enter the namespace for the song (for example customsongs): "
            case "name":
                return "Enter the name of the song (for example hypnoticbazaar): "
            case "noinput":
                return "No input."
            case "badinput":
                return "Bad input."
            case "mcmeta":
                return f"Assets for Funkalot custom level"
            case "success":
                return "Resource pack created successfully!"
            case "noffmpeg":
                return "Audio decoder not found. Select an ogg file."
            case _:
                return text
    match text:
        case "error":
            return "Ошибка"
        case "body":
            return "\nДобро пожаловать!\n"
        case "create":
            return "\n   Создать   \n"
        case "info":
            return "\nИнформация\n"
        case "infobody":
            return "\nЭта программа нужна для автоматического создания ресурспаков для карты Funkalot.\n\nОна не создаёт уровни автоматически, но даёт игре нужные ассеты для их создания, т.е. музыка и обложка."
        case "choosemusicfile":
            return "Выберите звуковой файл"
        case "mp3files":
            return "mp3 файлы"
        case "oggfiles":
            return "ogg файлы"
        case "chooseimagefile":
            return "Выберите изображение для обложки"
        case "pngfiles":
            return "png файлы"
        case "unsupportederror":
            return "Недопустимый или недоступный файл: "
        case "missingpatherror":
            return "Ожидался путь, но не был введён."
        case "allfiles":
            return "Все файлы"
        case "input":
            return "Ввод"
        case "namespace":
            return "Введите пространство имён для уровня (например, customsongs): "
        case "name":
            return "Введите название уровня (например, hypnoticbazaar): "
        case "noinput":
            return "Нет ввода."
        case "badinput":
            return "Недопустимый ввод."
        case "mcmeta":
            return f"Ресурсы для уровня Funkalot"
        case "success":
            return "Набор ресурсов успешно создан!"
        case "noffmpeg":
            return "Аудио декодер не найден. Выберите звуковой файл формата ogg."
        case _:
            return lang(text,"en_US")

